/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphBuilder;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.superplan.ProductionTreeVisitor;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.util.TimeSpan;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Superplan
implements ProductionTreeNode {
    private final Plan plan;
    private List<GeneralizedOrderRequest> gors;
    private List<CustomerRequest> customerReqs;
    private List<SupplyRequest> supplyReqs;
    private Map<String, GeneralizedOrderRequest> gorIdMap;
    private Map<String, SupplyRequest> supReqIdMap;
    private Map<String, CustomerRequest> custReqIdMap;
    private long fixationDate = -9223372036854775708L;
    private long stockInitDate = -9223372036854775708L;
    private long revision = 0L;
    private StoreDependencyGraph sdg;
    private final Lock sdGraphLock = new ReentrantLock();

    public Superplan(ShopConfiguration config) {
        this.plan = new Plan(config);
        this.gors = Lists.newArrayList();
        this.customerReqs = Lists.newArrayList();
        this.supplyReqs = Lists.newArrayList();
        this.gorIdMap = Maps.newHashMap();
        this.supReqIdMap = Maps.newHashMap();
        this.custReqIdMap = Maps.newHashMap();
    }

    @Override
    public void unsafeAddChild(ProductionTreeNode child) {
        if (!(child instanceof GeneralizedOrderRequest)) {
            throw new UnsupportedOperationException("Invalid type of PTN passed: " + child.getClass());
        }
        this.unsafeAddGor((GeneralizedOrderRequest)child);
    }

    public void unsafeAddGor(GeneralizedOrderRequest req) {
        Preconditions.checkArgument(!this.gorIdMap.containsKey(req.getId()), "Superplan already contains GOR with id %s", (Object)req.getId());
        req.setPlan(this.plan);
        this.gors.add(req);
        this.gorIdMap.put(req.getId(), req);
        req.unsafeSetParent(this);
    }

    @Override
    public ProductionTreeNode getParent() {
        return null;
    }

    @Override
    public void accept(ProductionTreeVisitor visitor, boolean childrenFirst) {
        if (!childrenFirst) {
            visitor.visit(this);
        }
        for (GeneralizedOrderRequest gor : this.gors) {
            gor.accept(visitor, childrenFirst);
        }
        if (childrenFirst) {
            visitor.visit(this);
        }
    }

    @Override
    public void unsafeSetParent(ProductionTreeNode parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void childChanged(ProductionTreeNode child) {
    }

    @Override
    public boolean unsafeRemoveChild(ProductionTreeNode child) {
        if (child instanceof GeneralizedOrderRequest) {
            return this.unsafeRemoveGor((GeneralizedOrderRequest)child);
        }
        throw new UnsupportedOperationException("Invalid type of PTN passed: " + child.getClass());
    }

    public boolean unsafeRemoveGor(GeneralizedOrderRequest gor) {
        if (this.gors.remove(gor)) {
            gor.unsafeSetParent(null);
            this.gorIdMap.remove(gor.getId());
            return true;
        }
        return false;
    }

    public boolean unsafeRenameGor(GeneralizedOrderRequest gor, String oldId, String newId) {
        if (!gor.getId().equals(oldId)) {
            throw new IllegalArgumentException("GOR " + gor + " and it's old id " + oldId + " are not the same.");
        }
        if (this.gorIdMap.containsKey(oldId)) {
            if (oldId.equals(newId)) {
                return true;
            }
            if (this.gorIdMap.containsKey(newId)) {
                throw new IllegalArgumentException("GOR with id " + newId + " is already in the superplan.");
            }
            this.gorIdMap.remove(oldId);
            this.gorIdMap.put(newId, gor);
            return true;
        }
        return false;
    }

    @Override
    public Superplan getSuperplan() {
        return this;
    }

    public List<GeneralizedOrderRequest> getGorsToPlan() {
        return Lists.newArrayList(Iterables.filter(this.getGors(), new Predicate<GeneralizedOrderRequest>(){

            @Override
            public boolean apply(GeneralizedOrderRequest gor) {
                return gor.isUserSelected();
            }
        }));
    }

    public void clearToFirstBottleneck(List<GeneralizedOrderRequest> gors, List<String> bottlenecks) {
        ProductionTreeAlgorithms.clearToFirstBottleneck(this, gors, bottlenecks);
    }

    public ProductionTreeAlgorithms.ClearResult clearPlan(List<Workplace> workplaceList, Long from, Long to, boolean clearOfflines, boolean clearAas, boolean clearRebuilds, boolean deleteOverlapping, boolean deleteAlternatives, ProductionTreeAlgorithms.FixationLevel fixationProtection) {
        return ProductionTreeAlgorithms.clearPlan(this, workplaceList, from, to, clearOfflines, clearAas, clearRebuilds, deleteOverlapping, deleteAlternatives, fixationProtection);
    }

    public String dumpProductionTree() {
        StringWriter out = new StringWriter();
        new ProductionTreeDumper(out).dumpProductionTree();
        return out.toString();
    }

    public Plan getPlan() {
        return this.plan;
    }

    public List<GeneralizedOrderRequest> getGors() {
        return Collections.unmodifiableList(this.gors);
    }

    public GeneralizedOrderRequest getGor(String gorId) {
        return this.gorIdMap.get(gorId);
    }

    public List<GeneralizedOrderRequest> getUserSelectedGors() {
        ArrayList<GeneralizedOrderRequest> l = new ArrayList<GeneralizedOrderRequest>(this.gors.size());
        for (GeneralizedOrderRequest gor : this.gors) {
            if (!gor.isUserSelected()) continue;
            l.add(gor);
        }
        return l;
    }

    public List<SupplyRequest> getSupplyRequests() {
        return Collections.unmodifiableList(this.supplyReqs);
    }

    public List<CustomerRequest> getCustomerRequests() {
        return Collections.unmodifiableList(this.customerReqs);
    }

    public List<MaterialRequest> getMaterialRequests() {
        return Collections3.joinLists(this.getCustomerRequests(), this.getSupplyRequests());
    }

    public ShopConfiguration getShopConf() {
        return this.plan.getShopConf();
    }

    public OfflineActivity newOffline(long start, long end, Workplace workplace) {
        WorkplaceSchedule schedule = this.getPlan().getWorkplaceSchedule(workplace);
        if (schedule.getActivityStartIncl(start) != null) {
            throw new IllegalArgumentException("New activity cannot start during other activity!");
        }
        WorkplaceActivity nextActivity = schedule.getNextActivity(start);
        if (nextActivity != null && nextActivity.getStart() < end) {
            end = nextActivity.getStart();
        }
        return new OfflineActivity(start, end, workplace);
    }

    public RebuildActivity newRebuild(long start, long end, Workplace workplace) {
        WorkplaceSchedule schedule = this.getPlan().getWorkplaceSchedule(workplace);
        if (schedule.getActivityStartIncl(start) != null) {
            throw new IllegalArgumentException("New activity cannot start during other activity!");
        }
        WorkplaceActivity nextActivity = schedule.getNextActivity(start);
        if (nextActivity != null && nextActivity.getStart() < end) {
            end = nextActivity.getStart();
        }
        return new RebuildActivity(start, end, workplace);
    }

    public ActionActivity newActionActivity(long start, double amount, Action action, Workplace workplace) {
        long end = action instanceof CumulativeAction ? start + action.getProductionTime() : start + action.timeToMake(amount);
        return this.newActionActivity(start, end, amount, action, workplace);
    }

    public ActionActivity newActionActivity(long start, long end, double amount, Action action, Workplace workplace) {
        boolean addingToCWA;
        WorkplaceSchedule schedule = this.getPlan().getWorkplaceSchedule(workplace);
        WorkplaceActivity collidingWa = schedule.getActivityStartIncl(start);
        boolean bl = addingToCWA = collidingWa instanceof CumulativeWorkplaceActivity && action instanceof CumulativeAction && ((CumulativeAction)action).getCumulationType().equals(((CumulativeWorkplaceActivity)collidingWa).getCumulationType());
        if (collidingWa != null && !addingToCWA) {
            throw new IllegalArgumentException("New activity cannot start during other activity!");
        }
        WorkplaceActivity nextActivity = schedule.getNextActivity(start);
        if (!addingToCWA && nextActivity != null && end > nextActivity.getStart()) {
            throw new IllegalArgumentException(String.format("Amount too big, cannot paste between %d and %d, crossing with %s.", start, end, nextActivity));
        }
        return new ActionActivity(start, end, workplace, action, amount);
    }

    public void addGor(GeneralizedOrderRequest gor) {
        ProductionTreeAlgorithms.addGor(this, gor);
    }

    public void addCustomerRequest(CustomerRequest custReq) {
        CustomerRequest prevCr = this.custReqIdMap.put(custReq.getId(), custReq);
        if (prevCr != null) {
            this.custReqIdMap.put(prevCr.getId(), prevCr);
            throw new IllegalArgumentException("Cannot add CR to superplan because of duplicate id " + custReq.getId());
        }
        this.customerReqs.add(custReq);
        custReq.setPlan(this.plan);
        custReq.setProperties(null, this.getShopConf().getPropertyDefinitionsInfoFor(CustomerRequest.class));
    }

    public void removeCustomerRequest(CustomerRequest custReq) {
        this.customerReqs.remove(custReq);
        custReq.setPlan(null);
        this.custReqIdMap.remove(custReq.getId());
    }

    public CustomerRequest getCustomerRequest(String id) {
        return this.custReqIdMap.get(id);
    }

    public void addSupplyRequest(SupplyRequest supReq) {
        SupplyRequest prevSr = this.supReqIdMap.put(supReq.getId(), supReq);
        if (prevSr != null) {
            this.supReqIdMap.put(prevSr.getId(), prevSr);
            throw new IllegalArgumentException("Cannot add SR to superplan because of duplicate id " + supReq.getId());
        }
        this.supplyReqs.add(supReq);
        supReq.setPlan(this.plan);
        supReq.setProperties(null, this.getShopConf().getPropertyDefinitionsInfoFor(SupplyRequest.class));
    }

    public void removeSupplyRequest(SupplyRequest supReq) {
        this.supplyReqs.remove(supReq);
        supReq.setPlan(null);
        this.supReqIdMap.remove(supReq.getId());
    }

    public SupplyRequest getSupplyRequest(String id) {
        return this.supReqIdMap.get(id);
    }

    public List<? extends ProductionTreeNode> removeGor(GeneralizedOrderRequest gor) {
        return ProductionTreeAlgorithms.removeGor(gor, this);
    }

    public void addOffline(OfflineActivity offline) {
        ProductionTreeAlgorithms.addOffline(this, offline);
    }

    public void addRebuild(RebuildActivity rebuild) {
        ProductionTreeAlgorithms.addRebuild(this, rebuild);
    }

    public void removeWorkplaceActivity(WorkplaceActivity wa) {
        ProductionTreeAlgorithms.removeWorkplaceActivity(this, wa);
    }

    public long getFixationDate() {
        return this.fixationDate;
    }

    public void setFixationDate(long fixationDate) {
        this.fixationDate = fixationDate;
    }

    public long getStockInitDate() {
        return this.stockInitDate;
    }

    public void setStockInitDate(long stockInitDate) {
        this.stockInitDate = stockInitDate;
    }

    public TimeSpan getTimeBounds() {
        TimeSpan planBounds = this.plan.getTimeBounds();
        TimeSpan productionTreeBounds = ProductionTreeAlgorithms.getTimeBounds(this);
        TimeSpan res = TimeSpan.union(planBounds, productionTreeBounds);
        if (GeneralizedRequest.isDateValid(this.fixationDate)) {
            res = TimeSpan.union(res, TimeSpan.fromStartEnd(this.fixationDate, this.fixationDate));
        }
        return res;
    }

    public Collection<ExternalStoreActivity> getUserSelectedStoreActivities() {
        Collection<ExternalStoreActivity> retVal = Collections2.filter(this.getExternalStoreActivities(StoreType.EXTERNAL), new Predicate<ExternalStoreActivity>(){

            @Override
            public boolean apply(ExternalStoreActivity input) {
                return input.isUserSelected();
            }
        });
        return retVal;
    }

    public List<ExternalStoreActivity> getExternalStoreActivities(StoreType storeType) {
        ArrayList<ExternalStoreActivity> res = new ArrayList<ExternalStoreActivity>();
        for (StoreActivity sa : this.getPlan().getStoreSchedule(storeType).activities()) {
            if (!(sa instanceof ExternalStoreActivity)) continue;
            res.add((ExternalStoreActivity)sa);
        }
        return res;
    }

    public ProductionTreeAlgorithms.ClearResult clearPlan(List<Workplace> workplaceList, Long from, Long to, boolean clearOfflines, boolean clearAas, boolean clearRebuilds, boolean deleteOverlapping, boolean deleteAlts, ProductionTreeAlgorithms.FixationLevel fixationProtection, boolean deleteBlockedGars) {
        return ProductionTreeAlgorithms.clearPlan(this, workplaceList, from, to, clearOfflines, clearAas, clearRebuilds, deleteOverlapping, deleteAlts, true, fixationProtection, !deleteBlockedGars);
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public StoreDependencyGraph getSDGraph() {
        this.sdGraphLock.lock();
        try {
            if (this.sdg == null) {
                this.sdg = StoreDependencyGraphBuilder.createWithPriorityFifo(this, StoreDependencyGraphBuilder.NodeMode.GOR).build();
            }
            StoreDependencyGraph storeDependencyGraph = this.sdg;
            return storeDependencyGraph;
        }
        finally {
            this.sdGraphLock.unlock();
        }
    }

    public void invalidateSDGraph() {
        this.sdGraphLock.lock();
        try {
            this.sdg = null;
        }
        finally {
            this.sdGraphLock.unlock();
        }
    }

    public boolean contains(ProductionTreeNode ptn) {
        return ptn != null && ProductionTreeAlgorithms.getSuperplan(ptn) == this;
    }

    public boolean contains(Activity activity) {
        return activity != null && activity.getPlan() == this.plan;
    }

    private class ProductionTreeDumper {
        private final PrintWriter out;

        public ProductionTreeDumper(Writer out) {
            this(new PrintWriter(out));
        }

        public ProductionTreeDumper(PrintWriter out) {
            this.out = out;
        }

        private void dumpGarTree(GeneralizedActionRequest gar, int level) {
            for (int i = 0; i < level; ++i) {
                this.out.write(32);
            }
            this.out.write(gar.toString());
            this.out.write(58);
            for (ActionActivity aa : gar.getActivities()) {
                this.out.write(" ");
                this.out.write(aa.toString());
            }
            this.out.write(10);
        }

        private void dumpGorTree(GeneralizedOrderRequest gor, int level) {
            for (int i = 0; i < level; ++i) {
                this.out.write(32);
            }
            this.out.write(gor.toString());
            this.out.write(10);
            for (GeneralizedActionRequest gar : gor.getGars()) {
                this.dumpGarTree(gar, level + 2);
            }
        }

        public void dumpProductionTree() {
            for (GeneralizedOrderRequest gor : Superplan.this.gors) {
                this.dumpGorTree(gor, 0);
            }
        }
    }
}

